<?php
function asaasRequest($endpoint, $method = 'POST', $data = null) {

    date_default_timezone_set('America/Sao_Paulo');
    
    $config = array(
        'db_user' => 'usuario do seu banco',
        'db_pass' => 'senha do seu banco',
        'db_name' => 'usuario do seu banco'
    );
    $conn = new mysqli('localhost', $config['db_user'], $config['db_pass'], $config['db_name']);

    if ($conn->connect_error) {
        return ['error' => true, 'message' => 'Erro na conexão com o banco: ' . $conn->connect_error];
    }

    $sql_asaas = "SELECT secret_key FROM ad_asaas WHERE id = 1";
    $stmt_asaas = $conn->prepare($sql_asaas);
    $stmt_asaas->execute();
    
    // precisa armazenar resultado para poder buscar
    $stmt_asaas->store_result();

    // vincular variáveis
    $stmt_asaas->bind_result($secret_key);

    if ($stmt_asaas->num_rows > 0) {
    $stmt_asaas->fetch();

}
     else {
        return ['error' => true, 'message' => 'Nenhum registro encontrado em ad_asaas'];
    }

    $stmt_asaas->close();
    $conn->close();

    if (empty($secret_key)) {
        return ['error' => true, 'message' => 'Secret key do Asaas não configurada'];
    }
    
    $apiKey = $secret_key;
    
        // var_dump($apiKey);die; // <- agora vai exibir
    $baseUrl = !empty($url) ? $url : "https://www.asaas.com/api/v3";
    $fullUrl = "$baseUrl/$endpoint";

    $headers = [
        "Content-Type: application/json",
        "access_token: $apiKey",
        "User-Agent: MyApp/1.0"
    ];

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $fullUrl,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => $method,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_SSL_VERIFYPEER => false,
    ]);

    if ($data) {
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    }

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        return ['curl_error' => curl_error($ch)];
    }
    curl_close($ch);
    return json_decode($response, true);
}
