<?php
require_once 'config.php';
require_once '../adquirente/asaas/asaas_functions.php';

header("Content-Type: application/json");

echo "=== TESTE DE CONEXÃO COM ASAAS ===\n\n";

// Teste 1: Verificar se a função está disponível
if (function_exists('asaasRequest')) {
    echo "✅ Função asaasRequest encontrada\n";
} else {
    echo "❌ Função asaasRequest não encontrada\n";
    exit;
}

// Teste 2: Testar criação de cliente
echo "\n--- Teste de Criação de Cliente ---\n";

$testData = [
    'name' => 'Teste API Gateway',
    'cpfCnpj' => '12345678901',
    'email' => 'teste@gateway.com'
];

try {
    $response = asaasRequest('customers', 'POST', $testData);
    
    if (isset($response['error'])) {
        echo "❌ Erro na criação do cliente:\n";
        echo "   HTTP Code: " . $response['http_code'] . "\n";
        echo "   Mensagem: " . $response['message'] . "\n";
        echo "   Resposta: " . json_encode($response['response'], JSON_PRETTY_PRINT) . "\n";
    } elseif (empty($response['id'])) {
        echo "❌ Cliente não foi criado. Resposta:\n";
        echo json_encode($response, JSON_PRETTY_PRINT) . "\n";
    } else {
        echo "✅ Cliente criado com sucesso!\n";
        echo "   ID: " . $response['id'] . "\n";
        echo "   Nome: " . $response['name'] . "\n";
        echo "   CPF: " . $response['cpfCnpj'] . "\n";
        echo "   Email: " . $response['email'] . "\n";
        
        // Teste 3: Testar criação de pagamento PIX
        echo "\n--- Teste de Criação de Pagamento PIX ---\n";
        
        $paymentData = [
            'customer' => $response['id'],
            'billingType' => 'PIX',
            'value' => 10.00,
            'dueDate' => date('Y-m-d'),
            'description' => 'Teste de pagamento PIX - API Gateway'
        ];
        
        $paymentResponse = asaasRequest('payments', 'POST', $paymentData);
        
        if (isset($paymentResponse['error'])) {
            echo "❌ Erro na criação do pagamento:\n";
            echo "   HTTP Code: " . $paymentResponse['http_code'] . "\n";
            echo "   Mensagem: " . $paymentResponse['message'] . "\n";
            echo "   Resposta: " . json_encode($paymentResponse['response'], JSON_PRETTY_PRINT) . "\n";
        } elseif (empty($paymentResponse['id'])) {
            echo "❌ Pagamento não foi criado. Resposta:\n";
            echo json_encode($paymentResponse, JSON_PRETTY_PRINT) . "\n";
        } else {
            echo "✅ Pagamento PIX criado com sucesso!\n";
            echo "   ID: " . $paymentResponse['id'] . "\n";
            echo "   Valor: R$ " . $paymentResponse['value'] . "\n";
            echo "   Status: " . $paymentResponse['status'] . "\n";
            echo "   Código PIX: " . ($paymentResponse['pix']['payload'] ?? 'N/A') . "\n";
        }
    }
    
} catch (Exception $e) {
    echo "❌ Exceção capturada: " . $e->getMessage() . "\n";
}

echo "\n=== FIM DO TESTE ===\n";
?>
