<?php
/**
 * Arquivo de teste para debug
 */

// Verificar se estamos no WordPress
if (!defined('ABSPATH')) {
    echo "ABSPATH não definido - não estamos no WordPress<br>";
    exit;
}

echo "ABSPATH definido: " . ABSPATH . "<br>";

// Verificar funções básicas do WordPress
if (function_exists('current_user_can')) {
    echo "✓ current_user_can existe<br>";
} else {
    echo "✗ current_user_can NÃO existe<br>";
}

if (function_exists('wp_die')) {
    echo "✓ wp_die existe<br>";
} else {
    echo "✗ wp_die NÃO existe<br>";
}

if (function_exists('wp_verify_nonce')) {
    echo "✓ wp_verify_nonce existe<br>";
} else {
    echo "✗ wp_verify_nonce NÃO existe<br>";
}

if (function_exists('update_option')) {
    echo "✓ update_option existe<br>";
} else {
    echo "✗ update_option NÃO existe<br>";
}

if (function_exists('sanitize_text_field')) {
    echo "✓ sanitize_text_field existe<br>";
} else {
    echo "✗ sanitize_text_field NÃO existe<br>";
}

if (function_exists('esc_url_raw')) {
    echo "✓ esc_url_raw existe<br>";
} else {
    echo "✗ esc_url_raw NÃO existe<br>";
}

if (function_exists('admin_url')) {
    echo "✓ admin_url existe<br>";
} else {
    echo "✗ admin_url NÃO existe<br>";
}

// Verificar se WooCommerce está ativo
if (class_exists('WooCommerce')) {
    echo "✓ WooCommerce está ativo<br>";
} else {
    echo "✗ WooCommerce NÃO está ativo<br>";
}

// Verificar se estamos logados como admin
if (current_user_can('manage_woocommerce')) {
    echo "✓ Usuário tem permissão para gerenciar WooCommerce<br>";
} else {
    echo "✗ Usuário NÃO tem permissão para gerenciar WooCommerce<br>";
}

echo "<br>Teste concluído!";
?>
