<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Documentação da API Gateway - Integração Asaas</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #333;
            color: #fff;
        }

        .container {
            max-width: 1000px;
            margin: 20px auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
        }

        h1, h2, h3 {
            text-align: center;
            color: #007bff;
        }

        h2 {
            border-bottom: 2px solid #007bff;
            padding-bottom: 10px;
            margin-top: 30px;
        }

        p {
            color: #666;
            line-height: 1.6;
        }

        code {
            background-color: #f8f9fa;
            padding: 2px 5px;
            border-radius: 3px;
            color: #333;
        }

        pre {
            background-color: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            overflow-x: auto;
            border-left: 4px solid #007bff;
            color: #333;
            line-height: 1.4;
            font-family: 'Courier New', monospace;
        }
        
        code {
            background-color: #e9ecef;
            color: #495057;
            padding: 2px 6px;
            border-radius: 3px;
            font-family: 'Courier New', monospace;
            font-size: 0.9em;
        }

        .success {
            background-color: #d4edda;
            border-color: #c3e6cb;
            color: #155724;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }

        .error {
            background-color: #f8d7da;
            border-color: #f5c6cb;
            color: #721c24;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }

        .info {
            background-color: #d1ecf1;
            border-color: #bee5eb;
            color: #0c5460;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }

        .endpoint {
            background-color: #f8f9fa;
            border: 1px solid #dee2e6;
            border-radius: 5px;
            padding: 15px;
            margin: 15px 0;
            color: #333;
        }

        .method {
            display: inline-block;
            padding: 4px 8px;
            border-radius: 4px;
            font-weight: bold;
            font-size: 12px;
            text-transform: uppercase;
        }

        .method.post {
            background-color: #28a745;
            color: white;
            font-weight: bold;
            text-shadow: 0 1px 2px rgba(0,0,0,0.3);
        }

        .method.get {
            background-color: #17a2b8;
            color: white;
            font-weight: bold;
            text-shadow: 0 1px 2px rgba(0,0,0,0.3);
        }

        .status-codes {
            margin: 20px 0;
        }

        .status-code {
            margin: 10px 0;
            padding: 12px 16px;
            border-radius: 6px;
            border-left: 4px solid;
            font-weight: 500;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }

        .status-200 { border-left-color: #28a745; background-color: #d4edda; color: #155724; }
        .status-400 { border-left-color: #ffc107; background-color: #fff3cd; color: #856404; }
        .status-401 { border-left-color: #dc3545; background-color: #f8d7da; color: #721c24; }
        .status-404 { border-left-color: #6c757d; background-color: #e2e3e5; color: #383d41; }
        .status-500 { border-left-color: #dc3545; background-color: #f8d7da; color: #721c24; }

        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }

        th, td {
            border: 1px solid #ddd;
            padding: 12px;
            text-align: left;
        }

        th {
            background-color: #007bff;
            color: white;
        }

        tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        
        tr:nth-child(odd) {
            background-color: #ffffff;
        }
        
        td {
            color: #333;
        }

        .note {
            background-color: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 5px;
            padding: 15px;
            margin: 20px 0;
            color: #856404;
        }
        
        .info {
            background-color: #d1ecf1;
            border: 1px solid #bee5eb;
            border-radius: 5px;
            padding: 15px;
            margin: 20px 0;
            color: #0c5460;
        }
    </style>
</head>

<body>
    <div class="container">
        <h1>Documentação da API Gateway - Integração Asaas</h1>

        <p>Bem-vindo à documentação da API Gateway! Esta API permite que você integre facilmente funcionalidades de pagamento PIX usando o Asaas como adquirente em seus aplicativos.</p>

        <div class="info">
            <h3>🔑 Autenticação</h3>
            <p>Todas as requisições devem incluir sua <code>api-key</code> no cabeçalho ou no corpo da requisição. Esta chave é única para cada usuário e pode ser obtida no painel administrativo.</p>
        </div>

        <h2>📋 Endpoints Disponíveis</h2>

        <div class="endpoint">
            <h3><span class="method post">POST</span> Criar Pagamento PIX</h3>
            <p><strong>URL:</strong> <code>https://velozpay.online/api./v1/gateway/criar-pagamento.php</code></p>
            <p>Cria um novo pagamento PIX e retorna os dados necessários para exibição ao cliente.</p>
        </div>

        <div class="endpoint">
            <h3><span class="method get">GET</span> Consultar Status</h3>
            <p><strong>URL:</strong> <code>https://velozpay.online/api./v1/gateway/consultar-status.php</code></p>
            <p>Consulta o status atual de uma transação específica.</p>
        </div>

        <h2>💳 Criar Pagamento PIX</h2>
        
        <h3>Endpoint</h3>
        <pre><code>POST https://velozpay.online/api./v1/gateway/criar-pagamento.php</code></pre>

        <h3>Parâmetros da Requisição</h3>
        <table>
            <tr>
                <th>Campo</th>
                <th>Tipo</th>
                <th>Obrigatório</th>
                <th>Descrição</th>
            </tr>
            <tr>
                <td>api-key</td>
                <td>string</td>
                <td>✅</td>
                <td>Sua chave de API única</td>
            </tr>
            <tr>
                <td>amount</td>
                <td>number</td>
                <td>✅</td>
                <td>Valor do pagamento (ex: 100.50)</td>
            </tr>
            <tr>
                <td>client.name</td>
                <td>string</td>
                <td>✅</td>
                <td>Nome completo do cliente</td>
            </tr>
            <tr>
                <td>client.document</td>
                <td>string</td>
                <td>✅</td>
                <td>CPF/CNPJ do cliente (apenas números)</td>
            </tr>
            <tr>
                <td>client.email</td>
                <td>string</td>
                <td>✅</td>
                <td>E-mail do cliente</td>
            </tr>
            <tr>
                <td>client.telefone</td>
                <td>string</td>
                <td>❌</td>
                <td>Telefone do cliente (apenas números)</td>
            </tr>
            <tr>
                <td>postback</td>
                <td>string</td>
                <td>❌</td>
                <td>URL para receber notificações de mudança de status</td>
            </tr>
        </table>

        <h3>Exemplo de Requisição</h3>
        <pre><code>{
    "amount": 100.50,
    "client": {
        "name": "Maria Oliveira Silva",
        "document": "12345678901",
        "telefone": "11999999999",
        "email": "maria.oliveira@email.com"
    },
    "api-key": "7115d6b39791cca550f4e3cc",
    "postback": "https://minhaloja.com/webhook/pagamento"
}</code></pre>

        <h3>Resposta de Sucesso (200 OK)</h3>
        <div class="success">
            <pre><code>{
    "status": "success",
    "message": "Pagamento PIX criado com sucesso",
    "data": {
        "idTransaction": "pay_123456789",
        "externalReference": "abc123def456ghi789",
        "paymentCode": "00020101021226790014br.gov.bcb.pix...",
        "paymentCodeBase64": "iVBORw0KGgoAAAANSUhEUgAA...",
        "amount": "100.50",
        "status": "WAITING_FOR_APPROVAL",
        "expiresAt": "2025-01-28",
        "pixKey": "chave-pix@asaas.com"
    }
}</code></pre>
        </div>

        <h2>🔍 Consultar Status</h2>
        
        <h3>Endpoint</h3>
        <pre><code>GET https://velozpay.online/api./v1/gateway/consultar-status.php</code></pre>

        <h3>Parâmetros da Requisição</h3>
        <table>
            <tr>
                <th>Campo</th>
                <th>Tipo</th>
                <th>Obrigatório</th>
                <th>Descrição</th>
            </tr>
            <tr>
                <td>api-key</td>
                <td>string</td>
                <td>✅</td>
                <td>Sua chave de API única</td>
            </tr>
            <tr>
                <td>idTransaction</td>
                <td>string</td>
                <td>❌</td>
                <td>ID da transação no Asaas (prioridade)</td>
            </tr>
            <tr>
                <td>externalReference</td>
                <td>string</td>
                <td>❌</td>
                <td>Referência externa da transação</td>
            </tr>
        </table>

        <div class="note">
            <strong>📝 Nota:</strong> É necessário informar pelo menos um dos campos: <code>idTransaction</code> ou <code>externalReference</code>.
        </div>

        <h3>Exemplo de Requisição</h3>
        <pre><code>GET https://velozpay.online/api./v1/gateway/consultar-status.php?api-key=7115d6b39791cca550f4e3cc&idTransaction=pay_123456789</code></pre>

        <h3>Resposta de Sucesso (200 OK)</h3>
        <div class="success">
            <pre><code>{
    "status": "success",
    "message": "Status consultado com sucesso",
    "data": {
        "idTransaction": "pay_123456789",
        "externalReference": "abc123def456ghi789",
        "amount": "100.50",
        "status": "PAID_OUT",
        "client": {
            "name": "Maria Oliveira Silva",
            "document": "12345678901",
            "email": "maria.oliveira@email.com",
            "telefone": "11999999999"
        },
        "createdAt": "2025-01-28 10:30:00",
        "adquirente": "asaas",
        "taxa_cash_in": "5.00",
        "deposito_liquido": "95.48",
        "asaas_status": "RECEIVED"
    }
}</code></pre>
        </div>

        <h2>📊 Códigos de Status</h2>
        
        <div class="status-codes">
            <div class="status-code status-200">
                <strong>200 OK</strong> - Requisição processada com sucesso
            </div>
            
            <div class="status-code status-400">
                <strong>400 Bad Request</strong> - Dados da requisição inválidos ou incompletos
            </div>
            
            <div class="status-code status-401">
                <strong>401 Unauthorized</strong> - API key inválida ou inativa
            </div>
            
            <div class="status-code status-404">
                <strong>404 Not Found</strong> - Transação não encontrada
            </div>
            
            <div class="status-code status-500">
                <strong>500 Internal Server Error</strong> - Erro interno do servidor
            </div>
        </div>

        <h2>🔄 Status das Transações</h2>
        
        <table>
            <tr>
                <th>Status</th>
                <th>Descrição</th>
                <th>Significado</th>
            </tr>
            <tr>
                <td>WAITING_FOR_APPROVAL</td>
                <td>Aguardando Aprovação</td>
                <td>Pagamento criado, aguardando confirmação</td>
            </tr>
            <tr>
                <td>PAID_OUT</td>
                <td>Pago</td>
                <td>Pagamento confirmado e processado</td>
            </tr>
            <tr>
                <td>OVERDUE</td>
                <td>Vencido</td>
                <td>Pagamento não foi realizado no prazo</td>
            </tr>
            <tr>
                <td>CANCELLED</td>
                <td>Cancelado</td>
                <td>Pagamento foi cancelado</td>
            </tr>
            <tr>
                <td>REFUNDED</td>
                <td>Estornado</td>
                <td>Pagamento foi estornado</td>
            </tr>
        </table>

        <h2>🔔 Webhook (Postback)</h2>
        
        <p>Se você configurar uma URL de postback, receberá notificações automáticas quando o status de um pagamento mudar:</p>

        <h3>Exemplo de Notificação</h3>
        <pre><code>{
    "amount": "100.50",
    "idTransaction": "pay_123456789",
    "externalReference": "abc123def456ghi789",
    "paymentMethod": "PIX",
    "status": "PAID_OUT",
    "timestamp": "2025-01-28T10:30:00Z"
}</code></pre>

        <h2>💡 Exemplos de Integração</h2>

        <h3>JavaScript (Fetch API)</h3>
        <pre><code>// Criar pagamento
const criarPagamento = async () => {
    const response = await fetch('https://velozpay.online/api./v1/gateway/criar-pagamento.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({
            amount: 100.50,
            client: {
                name: "João Silva",
                document: "12345678901",
                email: "joao@email.com",
                telefone: "11999999999"
            },
            "api-key": "sua_api_key_aqui",
            postback: "https://sualoja.com/webhook"
        })
    });
    
    const data = await response.json();
    console.log(data);
};

// Consultar status
const consultarStatus = async (idTransaction) => {
    const response = await fetch(`https://velozpay.online/api./v1/gateway/consultar-status.php?api-key=sua_api_key_aqui&idTransaction=${idTransaction}`);
    const data = await response.json();
    console.log(data);
};</code></pre>

        <h3>PHP (cURL)</h3>
        <pre><code>// Criar pagamento
$data = [
    'amount' => 100.50,
    'client' => [
        'name' => 'João Silva',
        'document' => '12345678901',
        'email' => 'joao@email.com',
        'telefone' => '11999999999'
    ],
    'api-key' => 'sua_api_key_aqui',
    'postback' => 'https://sualoja.com/webhook'
];

$ch = curl_init('https://velozpay.online/api./v1/gateway/criar-pagamento.php');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);

$response = curl_exec($ch);
curl_close($ch);

$result = json_decode($response, true);
print_r($result);</code></pre>

        <h2>⚠️ Tratamento de Erros</h2>
        
        <div class="error">
            <h3>Exemplo de Erro (400 Bad Request)</h3>
            <pre><code>{
    "status": "error",
    "message": "Dados obrigatórios ausentes. Necessário: amount, client, api-key"
}</code></pre>
        </div>

        <div class="error">
            <h3>Exemplo de Erro (401 Unauthorized)</h3>
            <pre><code>{
    "status": "error",
    "message": "API key inválida ou inativa"
}</code></pre>
        </div>

        <div class="error">
            <h3>Exemplo de Erro (404 Not Found)</h3>
            <pre><code>{
    "status": "error",
    "message": "Transação não encontrada"
}</code></pre>
        </div>

        <h2>🔧 Suporte</h2>
        
        <p>Para suporte técnico ou dúvidas sobre a integração, entre em contato através do painel administrativo ou envie um e-mail para o suporte.</p>

        <div class="note">
            <strong>🚀 Dica:</strong> Sempre teste suas integrações em ambiente de desenvolvimento antes de usar em produção!
        </div>
    </div>
</body>
</html>