<?php
session_start();
if (!isset($_SESSION['email']) || !isset($_SESSION['user_id'])) {
    header('Location: ../');
    exit;
}

include '../conectarbanco.php';

$conn = new mysqli('localhost', $config['db_user'], $config['db_pass'], $config['db_name']);
if ($conn->connect_error) {
    die('Erro na conexão: ' . $conn->connect_error);
}

$user_id = $_SESSION['user_id'];
$google_snippet_code = isset($_POST['google_snippet_code']) ? trim($_POST['google_snippet_code']) : '';
$google_label = isset($_POST['google_label']) ? trim($_POST['google_label']) : '';

if ($google_snippet_code === '' || $google_label === '') {
    header('Location: ./?error=Campos obrigatórios');
    exit;
}

$sql = "INSERT INTO integracoes_ads (user_id, google_snippet_code, google_label) VALUES (?, ?, ?) 
        ON DUPLICATE KEY UPDATE google_snippet_code = VALUES(google_snippet_code), google_label = VALUES(google_label)";
$stmt = $conn->prepare($sql);
$stmt->bind_param('sss', $user_id, $google_snippet_code, $google_label);
$stmt->execute();
$stmt->close();
$conn->close();

header('Location: ./?saved=google');
exit;
?>


