<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "=== TESTE DE INCLUSÃO DO ARQUIVO ===\n\n";

echo "1. Diretório atual (__DIR__): " . __DIR__ . "\n";
echo "2. Diretório pai (dirname(__DIR__)): " . dirname(__DIR__) . "\n\n";

// Testar diferentes caminhos
$possiblePaths = [
    __DIR__ . '/../adquirente/asaas/asaas_functions.php',
    dirname(__DIR__) . '/adquirente/asaas/asaas_functions.php',
    realpath(__DIR__ . '/../adquirente/asaas/asaas_functions.php'),
    'adquirente/asaas/asaas_functions.php',
    '../adquirente/asaas/asaas_functions.php'
];

echo "3. TESTANDO CAMINHOS:\n";
foreach ($possiblePaths as $index => $path) {
    $exists = file_exists($path);
    $status = $exists ? "✅ EXISTE" : "❌ NÃO EXISTE";
    echo "   Caminho " . ($index + 1) . ": $path - $status\n";
    
    if ($exists) {
        echo "      Tamanho: " . filesize($path) . " bytes\n";
        echo "      Permissões: " . substr(sprintf('%o', fileperms($path)), -4) . "\n";
    }
}

echo "\n4. TENTANDO INCLUIR:\n";
$asaasFunctionsLoaded = false;
foreach ($possiblePaths as $index => $path) {
    if (file_exists($path)) {
        echo "   Tentando incluir: $path\n";
        try {
            require_once $path;
            echo "   ✅ Arquivo incluído com sucesso!\n";
            $asaasFunctionsLoaded = true;
            break;
        } catch (Exception $e) {
            echo "   ❌ Erro ao incluir: " . $e->getMessage() . "\n";
        } catch (Error $e) {
            echo "   ❌ Erro fatal ao incluir: " . $e->getMessage() . "\n";
        }
    }
}

echo "\n5. VERIFICANDO FUNÇÃO:\n";
if (function_exists('asaasRequest')) {
    echo "   ✅ Função asaasRequest está disponível\n";
} else {
    echo "   ❌ Função asaasRequest NÃO está disponível\n";
}

echo "\n6. TESTE DE FUNÇÃO:\n";
if (function_exists('asaasRequest')) {
    try {
        $result = asaasRequest('test', 'GET');
        echo "   ✅ Função executada com sucesso\n";
        echo "   Resultado: " . json_encode($result) . "\n";
    } catch (Exception $e) {
        echo "   ❌ Erro ao executar função: " . $e->getMessage() . "\n";
    }
}

echo "\n=== FIM DO TESTE ===\n";
?>
